//******************************************************************************
// Copyright (c) ACE CAD Enterprise Co., Ltd.  All rights reserved.            *
//                                                                             *
// This source code is subject to demostrate the decoding of the ACECAD Ink    *
// file (.DHW file). The code and information provided here is for reference   *
// purpose only. Please refers to the ACECAD Ink File Format document for the  *
// detailed description of the Ink data.                                       *
// *****************************************************************************
//
// DHWSampleDoc.cpp : implementation of the CDHWSampleDoc class
//

#include "stdafx.h"
#include "DHWSample.h"

#include "DHWSampleDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

double tablet_width=0.0,tablet_height=0.0;
extern CRect Handwriting_Rect;
CArray<Point_Record,Point_Record> ptArray;

/////////////////////////////////////////////////////////////////////////////
// CDHWSampleDoc

IMPLEMENT_DYNCREATE(CDHWSampleDoc, CDocument)

BEGIN_MESSAGE_MAP(CDHWSampleDoc, CDocument)
	//{{AFX_MSG_MAP(CDHWSampleDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDHWSampleDoc construction/destruction

CDHWSampleDoc::CDHWSampleDoc()
{
	// TODO: add one-time construction code here

}

CDHWSampleDoc::~CDHWSampleDoc()
{
}

BOOL CDHWSampleDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CDHWSampleDoc serialization

void CDHWSampleDoc::Serialize(CArchive& ar)
{
	//if (ar.IsStoring())
	//{
		// TODO: add storing code here
	//}
	//else
	//{
		// TODO: add loading code here
	//}
	if (ar.IsLoading())
	{
		CFile* fp = ar.GetFile();
		ULONGLONG dwLength = fp->GetLength();

		BYTE *lpBuffer=new BYTE[(UINT)dwLength+1];
		UINT nr = ar.Read( lpBuffer, (UINT)dwLength );
		lpBuffer[dwLength]=0;
        ////////////////////////////
		int bx1=0,bx2=0,by1=0,by2=0;
		//get page size
		bx1=(int)lpBuffer[33];
		bx2=(int)lpBuffer[34];
		by1=(int)lpBuffer[35];
		by2=(int)lpBuffer[36];
		tablet_width=double(bx1+(bx2<<8));
		tablet_height=double(by1+(by2<<8));
		//get coordinate data

		BYTE tmpBuffer=0;
		BOOL PenDown=FALSE;
		int Hw_Rt_width=Handwriting_Rect.Width(),Hw_Rt_height=Handwriting_Rect.Height();
		struct Point_Record P_Record;
		int rq=0,clearq=0;
		ptArray.RemoveAll();
		for(int q=40;q<dwLength;q++)
		{
			//head,tail
			if(lpBuffer[q]>=0x80)
			{
				switch(lpBuffer[q])
				{
				case 0x81:
				case 0x83:
				case 0x85:
				case 0x87:
						{
							if(PenDown==FALSE)//get new data
							{
								PenDown=TRUE;
								tmpBuffer=lpBuffer[q];
								rq=(int)ptArray.GetSize();
							}
							else//clear
							{
								clearq=((int)ptArray.GetSize())-rq;
								if(clearq>0)
									ptArray.RemoveAt(rq,clearq);
							}
							
						}break;
				case 0x80:
				case 0x82:
				case 0x84:
				case 0x86:
					{
						if(PenDown==FALSE)break;

						P_Record.PenState=lpBuffer[q];
						bx1=0;
						bx2=0;
						by1=0;
						by2=0;
						bx1=(int)lpBuffer[q+1];
						bx2=(int)lpBuffer[q+2];
						by1=(int)lpBuffer[q+3];
						by2=(int)lpBuffer[q+4];
						q=q+4;
						bx1=bx1+(bx2<<7);
						by1=by1+(by2<<7);
						P_Record.tablet_pt=CPoint(bx1,by1);
						bx1=(int)(((double)(bx1*Hw_Rt_width))/tablet_width);
						by1=(int)(((double)((tablet_height-by1)*Hw_Rt_height))/tablet_height);
						P_Record.pt=CPoint(bx1,by1);
						ptArray.Add(P_Record);						
						
						PenDown=FALSE;
					}break;
				case 0x88:
				case 0x90:
					{
						q++;
						if(PenDown==TRUE)
						{
							//clear
							clearq=((int)ptArray.GetSize())-rq;
							if(clearq>0)
								ptArray.RemoveAt(rq,clearq);
							PenDown=FALSE;
						}
					}break;
				default:
					{
						//clear
						clearq=((int)ptArray.GetSize())-rq;
						if(clearq>0)
							ptArray.RemoveAt(rq,clearq);
						PenDown=FALSE;
					}break;
				}
				continue;
			}
			//body
			if(PenDown==FALSE)continue;
			
			P_Record.PenState=tmpBuffer;
			bx1=0;
			bx2=0;
			by1=0;
			by2=0;
			bx1=(int)lpBuffer[q];
			bx2=(int)lpBuffer[q+1];
			by1=(int)lpBuffer[q+2];
			by2=(int)lpBuffer[q+3];
			q=q+3;
			bx1=bx1+(bx2<<7);
			by1=by1+(by2<<7);
			P_Record.tablet_pt=CPoint(bx1,by1);
			bx1=(int)(((double)(bx1*Hw_Rt_width))/tablet_width);
			by1=(int)(((double)((tablet_height-by1)*Hw_Rt_height))/tablet_height);
			P_Record.pt=CPoint(bx1,by1);
			ptArray.Add(P_Record);
		}
        ////////////////////////////
		delete [] lpBuffer;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CDHWSampleDoc diagnostics

#ifdef _DEBUG
void CDHWSampleDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CDHWSampleDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDHWSampleDoc commands

BOOL CDHWSampleDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	
	CString str(lpszPathName);
	if(str.Right(4)!=".DHW")
		if(str.Right(4)!=".dhw")
		{
			AfxMessageBox("Can't open file !");
			return FALSE;		
		}

	return TRUE;
}
